%****************************************************************
%                   Hochschule Hamm-Lippstadt                   *
%****************************************************************
% Modul	          : Messunsicherheit_IR.m                       *
%                                                               *
% Datum           : 01.01.2026                                  *
%                                                               *
% Funktion        : Berechnung der Standarunsicherheiten und    *
%                   der Abweichungen vom Messergebnis für den   *
%                   Sharp IR Distanzsensor                      *
%                                                               *
% Implementation  : MATLAB 2024b                                *
%                                                               *
% Req. Toolbox    : Statistics and Machine Learning Toolbox     *
%                                                               *
% Author          : Kilian Engelhardt, Daniel Block             *
%                                                               *
% Bemerkung       : Basierend auf dem Programmcode von 
%                   https://wiki.hshl.de/wiki/index.php/Zeit-,_Entfernungs-_und_Gewichtsschätzung*
%                                                               *
% Letzte Änderung : 01.01.2026                                  *
%****************************************************************
clc; clear all; close all;

%% Messungen laden und verarbeiten
Gesamtmessung = [14.399, 14.735, 14.256, 14.399, 14.727]; % Zeit in Sekunden

%% Mittelwerte berechnen
R = mean(Gesamtmessung(:));  % Mittelwert der Messwerte

%% Empirische Standardabweichung bestimmen
s = std(Gesamtmessung(:));  % Standardabweichung der Messwerte

%% Standardunsicherheit Typ A bestimmen
p = 0.95;  % Vertrauensniveau (95%)
n = length(Gesamtmessung); % Anzahl der Messwerte
nu = n - 1; % Freiheitsgrade
t = tinv((1 + p) / 2, nu); % t-Quantil
uA = s * t / sqrt(n);  % Standardunsicherheit Typ A

%% Standardunsicherheit Typ B bestimmen
% Annahmen für Typ-B-Unsicherheit
sim_aufloesung = 0.02;  % Zeitauflösung des Systems in Sekunden
taster_latenzzeit = 0.02;  % Latenz des Tasters in Sekunden

% Typ-B-Unsicherheit
uB = sqrt((sim_aufloesung^2 / 3) + (taster_latenzzeit^2 / 3));  % Typ-B-Unsicherheit

%% Kombinierte Standardunsicherheit Typ C bestimmen
uC = sqrt(uA^2 + uB^2);  % Kombinierte Unsicherheit

%% Grad des Vertrauens bestimmen
k = 2;  % Vertrauensfaktor für 95% Konfidenzniveau

% Absolute Messunsicherheit bestimmen
uAbs = k * uC;

% Relative Messunsicherheit berechnen (%)
uRel = (uAbs / R) * 100;

%% Ergebnisdarstellung Typ C
figure;
yline(R, 'Color', 'k', 'DisplayName', 'Mittelwert');
yline(14.5, 'Color', 'g', 'DisplayName', 'Wahrer Wert = 14,5 cm');
xlim([0 n]);
grid on;
hold on;
plot([0 n], [R + uC R + uC], '--b', [0 n], [R - uC R - uC], '--b', 'DisplayName', 'Unsicherheit Typ C');
plot(1:n, Gesamtmessung, '*-', 'DisplayName', 'Messwerte');  % Mittelwerte plotten
xlabel('Anzahl der Messpunkte');
ylabel('Distanz in cm');
xlim([1 5])
ylim([14 15]);
title(['IR-Sensor Messunsicherheit (Mittelwert = ', num2str(R), 's, Unsicherheit = \pm', num2str(uC), 's, ', num2str(uRel), '%)']);
grid on;
legend;